/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.entity.projectile.ExplosivePokemonProjectile;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class PokemonTracingBullet
extends ExplosivePokemonProjectile {
    private static final double SPEED = 0.2;
    private static final int min_interval = 10;
    private static final int random_interval = 2;
    @Nullable
    private class_1297 finalTarget;
    @Nullable
    private class_2350 currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;

    public PokemonTracingBullet(class_1299<? extends PokemonTracingBullet> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5960 = true;
    }

    public PokemonTracingBullet(class_1937 level, class_1309 shooter, class_1297 finalTarget, class_2350.class_2351 axis) {
        super((class_1299<? extends AbstractPokemonProjectile>)((class_1299)EntityFightOrFlight.TRACING_BULLET.get()), level);
        this.initPosition(shooter);
        this.method_7432((class_1297)shooter);
        this.finalTarget = finalTarget;
        this.currentMoveDirection = class_2350.field_11036;
        this.selectNextMoveDirection(axis);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.finalTarget != null) {
            compound.method_25927("Target", this.finalTarget.method_5667());
        }
        if (this.getMoveDirection() != null) {
            compound.method_10569("Dir", this.currentMoveDirection.method_10146());
        }
        compound.method_10569("Steps", this.flightSteps);
        compound.method_10549("TXD", this.targetDeltaX);
        compound.method_10549("TYD", this.targetDeltaY);
        compound.method_10549("TZD", this.targetDeltaZ);
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.flightSteps = compound.method_10550("Steps");
        this.targetDeltaX = compound.method_10574("TXD");
        this.targetDeltaY = compound.method_10574("TYD");
        this.targetDeltaZ = compound.method_10574("TZD");
        if (compound.method_10573("Dir", 99)) {
            this.currentMoveDirection = class_2350.method_10143((int)compound.method_10550("Dir"));
        }
        if (compound.method_25928("Target")) {
            this.targetId = compound.method_25926("Target");
        }
    }

    @Nullable
    private class_2350 getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable class_2350 direction) {
        this.currentMoveDirection = direction;
    }

    private void selectNextMoveDirection(@Nullable class_2350.class_2351 axis) {
        class_2338 blockPos;
        double d = 0.5;
        if (this.finalTarget == null || !this.finalTarget.method_5805()) {
            blockPos = this.method_24515().method_10074();
        } else {
            d = (double)this.finalTarget.method_17682() * 0.7;
            blockPos = class_2338.method_49637((double)this.finalTarget.method_23317(), (double)(this.finalTarget.method_23318() + d), (double)this.finalTarget.method_23321());
        }
        double e = (double)blockPos.method_10263() + 0.5;
        double f = (double)blockPos.method_10264() + d;
        double g = (double)blockPos.method_10260() + 0.5;
        class_2350 direction = null;
        if (!blockPos.method_19769((class_2374)this.method_19538(), 2.0)) {
            class_2338 blockPos2 = this.method_24515();
            ArrayList list = Lists.newArrayList();
            if (axis != class_2350.class_2351.field_11048) {
                if (blockPos2.method_10263() < blockPos.method_10263() && this.method_37908().method_22347(blockPos2.method_10078())) {
                    list.add(class_2350.field_11034);
                } else if (blockPos2.method_10263() > blockPos.method_10263() && this.method_37908().method_22347(blockPos2.method_10067())) {
                    list.add(class_2350.field_11039);
                }
            }
            if (axis != class_2350.class_2351.field_11052) {
                if (blockPos2.method_10264() < blockPos.method_10264() && this.method_37908().method_22347(blockPos2.method_10084())) {
                    list.add(class_2350.field_11036);
                } else if (blockPos2.method_10264() > blockPos.method_10264() && this.method_37908().method_22347(blockPos2.method_10074())) {
                    list.add(class_2350.field_11033);
                }
            }
            if (axis != class_2350.class_2351.field_11051) {
                if (blockPos2.method_10260() < blockPos.method_10260() && this.method_37908().method_22347(blockPos2.method_10072())) {
                    list.add(class_2350.field_11035);
                } else if (blockPos2.method_10260() > blockPos.method_10260() && this.method_37908().method_22347(blockPos2.method_10095())) {
                    list.add(class_2350.field_11043);
                }
            }
            direction = class_2350.method_10162((class_5819)this.field_5974);
            if (!list.isEmpty()) {
                direction = (class_2350)list.get(this.field_5974.method_43048(list.size()));
            }
            for (int i = 5; !this.method_37908().method_22347(blockPos2.method_10093(direction)) && i > 0; --i) {
                direction = class_2350.method_10162((class_5819)this.field_5974);
            }
            if (this.finalTarget == null && this.method_24921() != null) {
                direction = class_2350.field_11033;
            }
            e = this.method_23317() + (double)direction.method_10148();
            f = this.method_23318() + (double)direction.method_10164();
            g = this.method_23321() + (double)direction.method_10165();
        }
        this.setMoveDirection(direction);
        double h = e - this.method_23317();
        double j = f - this.method_23318();
        double k = g - this.method_23321();
        double l = Math.sqrt(h * h + j * j + k * k);
        if (l == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = h / l * 0.2;
            this.targetDeltaY = j / l * 0.2;
            this.targetDeltaZ = k / l * 0.2;
        }
        this.field_6007 = true;
        this.flightSteps = 10 + this.field_5974.method_43048(2) * 3;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
    }

    @Override
    public void method_5773() {
        class_243 vec3;
        super.method_5773();
        if (!this.method_37908().field_9236) {
            class_239 hitResult;
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((class_3218)this.method_37908()).method_14190(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (this.canAttackTarget()) {
                this.targetDeltaX = class_3532.method_15350((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = class_3532.method_15350((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = class_3532.method_15350((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                vec3 = this.method_18798();
                this.method_18799(vec3.method_1031((this.targetDeltaX - vec3.field_1352) * 0.2, (this.targetDeltaY - vec3.field_1351) * 0.2, (this.targetDeltaZ - vec3.field_1350) * 0.2));
            }
            if ((hitResult = class_1675.method_49997((class_1297)this, this::method_26958)).method_17783() != class_239.class_240.field_1333) {
                this.method_7488(hitResult);
            }
        }
        this.method_5852();
        vec3 = this.method_18798();
        this.method_5814(this.method_23317() + vec3.field_1352, this.method_23318() + vec3.field_1351, this.method_23321() + vec3.field_1350);
        class_1675.method_7484((class_1297)this, (float)0.5f);
        if (this.method_37908().field_9236) {
            this.makeParticle(1);
        } else if (this.finalTarget != null && !this.finalTarget.method_31481()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.getMoveDirection() == null ? null : this.getMoveDirection().method_10166());
                }
            }
            if (this.getMoveDirection() != null) {
                class_2338 blockPos = this.method_24515();
                class_2350.class_2351 axis = this.getMoveDirection().method_10166();
                if (this.method_37908().method_8515(blockPos.method_10093(this.getMoveDirection()), (class_1297)this)) {
                    this.selectNextMoveDirection(axis);
                } else {
                    class_2338 blockPos2 = this.finalTarget.method_24515();
                    if (axis == class_2350.class_2351.field_11048 && blockPos.method_10263() == blockPos2.method_10263() || axis == class_2350.class_2351.field_11051 && blockPos.method_10260() == blockPos2.method_10260() || axis == class_2350.class_2351.field_11052 && blockPos.method_10264() == blockPos2.method_10264()) {
                        this.selectNextMoveDirection(axis);
                    }
                }
            }
        }
    }

    protected double method_7490() {
        if (this.canAttackTarget()) {
            return 0.0;
        }
        return 0.04;
    }

    protected boolean canAttackTarget() {
        return this.finalTarget != null && this.finalTarget.method_5805() && (!(this.finalTarget instanceof class_1657) || !this.finalTarget.method_7325());
    }

    @Override
    protected boolean method_26958(class_1297 target) {
        return super.method_26958(target) && !target.field_5960;
    }

    public boolean method_5809() {
        return false;
    }

    public boolean method_5640(double distance) {
        return distance < 16384.0;
    }

    @Override
    protected void method_7454(class_3966 result) {
        class_1297 owner;
        class_1297 target = result.method_17782();
        if (!target.equals((Object)(owner = this.method_24921()))) {
            if (target instanceof class_1676) {
                class_1676 projectile = (class_1676)target;
                if (owner != null && owner.equals((Object)projectile.method_24921())) {
                    return;
                }
            }
            super.method_7454(result);
        }
    }

    @Override
    protected void method_24920(class_3965 result) {
        super.method_24920(result);
    }

    private void destroy() {
        this.method_31472();
        this.method_37908().method_32888((class_6880)class_5712.field_28736, this.method_19538(), class_5712.class_7397.method_43285((class_1297)this));
    }

    protected void method_7488(class_239 result) {
        super.method_7488(result);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236) {
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11205, this.method_23317(), this.method_23318(), this.method_23321(), 15, 0.2, 0.2, 0.2, 0.0);
            this.destroy();
        }
        return true;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        double d = packet.method_11170();
        double e = packet.method_11172();
        double f = packet.method_11173();
        this.method_18800(d, e, f);
    }
}

