/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.yajatkaul.mega_showdown.datapack.showdown;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownService;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.cobblemon.yajatkaul.mega_showdown.MegaShowdown;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public class TypeCharts
implements DataRegistry {
    private static final class_2960 ID = class_2960.method_60655((String)"mega_showdown", (String)"showdown/typecharts");
    private static final SimpleObservable<TypeCharts> OBSERVABLE = new SimpleObservable();
    public static final TypeCharts INSTANCE = new TypeCharts();
    private final Map<String, String> typeChartScripts = new HashMap<String, String>();

    private TypeCharts() {
        OBSERVABLE.subscribe(Priority.NORMAL, this::typeChartsLoad);
    }

    public Unit typeChartsLoad(DataRegistry typeChart) {
        this.registerTypeCharts();
        return Unit.INSTANCE;
    }

    public Map<String, String> getTypeChartScripts() {
        return this.typeChartScripts;
    }

    @NotNull
    public class_2960 getId() {
        return ID;
    }

    @NotNull
    public SimpleObservable<? extends DataRegistry> getObservable() {
        return OBSERVABLE;
    }

    public void reload(@NotNull class_3300 resourceManager) {
        this.typeChartScripts.clear();
        resourceManager.method_41265("showdown/typecharts", path -> path.method_12832().endsWith(".js")).forEach((id, resources) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)resources.getLast()).method_14482(), StandardCharsets.UTF_8));){
                String js = reader.lines().collect(Collectors.joining("\n"));
                String typeChartId = new File(id.method_12832()).getName().replace(".js", "");
                this.typeChartScripts.put(typeChartId, js);
            }
            catch (IOException e) {
                MegaShowdown.LOGGER.error("Failed to load typechart script: {} {}", id, (Object)e);
            }
        });
        OBSERVABLE.emit((Object[])new TypeCharts[]{this});
    }

    public void registerTypeCharts() {
        Cobblemon.INSTANCE.getShowdownThread().queue(showdownService -> {
            if (showdownService instanceof GraalShowdownService) {
                GraalShowdownService service = (GraalShowdownService)showdownService;
                Value receiveTypeChartDataFn = service.context.getBindings("js").getMember("receiveTypeChartData");
                for (Map.Entry<String, String> entry : INSTANCE.getTypeChartScripts().entrySet()) {
                    String typeChartId = entry.getKey();
                    String js = entry.getValue().replace("\n", " ");
                    receiveTypeChartDataFn.execute(new Object[]{typeChartId, js});
                }
            }
            return Unit.INSTANCE;
        });
    }

    @NotNull
    public class_3264 getType() {
        return class_3264.field_14190;
    }

    public void sync(@NotNull class_3222 serverPlayerEntity) {
    }
}

